/************************************************************************
 *
 *  project_config.h
 *
 *  external parameters was included in this file
 * 
 *
 ************************************************************************/

#ifndef PROJECT_CONFIG_H
#define PROJECT_CONFIG_H
//********************************************************************
//Board Components
//********************************************************************
//flag                      value
//********************************************************************
#define Board_CPU_MARS
#define Board_Chip_Rev_1283
#define Board_HWSETTING_qa___2DDR.LowPLL
#define Board_DRAM_Block			128
#define Board_DRAM_Number			2
#define Board_DRAM_Size				256
#define Board_SATA_NULL
#define Board_IDE_NULL
#define Board_USB_Driver_Disabled
#define Board_IDE2_NULL
#define Board_LAN_8139cp
#define Board_RTC_default
#define Board_VFD_mele
#define Board_GPIO_NULL
#define Board_PWM_NULL
#define Board_TVD_default
#define Board_LCD_CONTROL_NULL
//********************************************************************
//GPIO setup
//********************************************************************
//flag                      value
//********************************************************************
#define GPIO_MUXPAD0			0x00030010     // address: 1800_0350
#define GPIO_MUXPAD1			0x00000000     // address: 1800_0354
#define GPIO_MUXPAD2			0x00000000     // address: 1800_0358
#define GPIO_MUXPAD3			0x00000000     // address: 1800_035c
#define GPIO_MUXPAD4			0x00000000     // address: 1800_0360
#define GPIO_MUXPAD5			0x00000008     // address: 1800_0364
#define GPIO_MUXPAD6			0x08aa22aa     // address: 1800_0368
#define GPIO_MUXPAD7			0x00000100     // address: 1800_036c
#define GPIO_GP1DIR			0x00001800     // address: 1801_b104
#define GPIO_GP3DIR			0x00000040     // address: 1801_b10c
#define GPIO_GP1DATO			0x00001800     // address: 1801_b114
#define GPIO_GP3DATO			0x00000000     // address: 1801_b11c
//********************************************************************
//Config
//********************************************************************
//flag                      value
//********************************************************************
#define Config_Product_avhdd
#define Config_Encryption_FALSE
#define Config_PLL_Prog_FALSE
#define Config_Time_Evaluation_FALSE
//********************************************************************
//config HDMI Keys
//********************************************************************
//flag                      value
//********************************************************************
//********************************************************************
//config password to allow input from UART when secure boot (maximum 255)
//********************************************************************
//flag                      value
//********************************************************************
//********************************************************************
//RSA key file & AES key file (under bin/image)
//********************************************************************
//flag                      value
//********************************************************************
//********************************************************************
//Boot parameters
//********************************************************************
//flag                      value
//********************************************************************
#define Param_companyID			"0000"
#define Param_boardID			"0201"
#define Param_version			"1026U"
#define Param_MAC_hi			0x00112233
#define Param_MAC_lo			0x44550000
//********************************************************************
//Logo attribute
//********************************************************************
//flag                      value
//********************************************************************
#define Logo_Source_FLASH
#define Logo_Offset			2575
#define Logo_Reg5370			0x808010
#define Logo_Reg5374			0x8080eb
#define Logo_Reg5378			0xb46110
#define Logo_Reg537c			0x004034
#define Logo_Type_PAL
#define Logo_File_Name			"logo_Emtec_V800H_PAL.bmp"
#define Logo2_Source_FLASH
#define Logo2_Offset			2575
#define Logo2_Reg5370			0x808010
#define Logo2_Reg5374			0x8080eb
#define Logo2_Reg5378			0xb46110
#define Logo2_Reg537c			0x004034
#define Logo2_Type_PAL
#define Logo2_File_Name			"logo_Emtec_V800H_PAL.bmp"
#define Logo3_Source_FLASH
#define Logo3_Offset			2575
#define Logo3_Reg5370			0x808010
#define Logo3_Reg5374			0x8080eb
#define Logo3_Reg5378			0xb46110
#define Logo3_Reg537c			0x004034
#define Logo3_Type_PAL
#define Logo3_File_Name			"logo_Emtec_V800H_PAL.bmp"
#define Logo4_Source_FLASH
#define Logo4_Offset			2575
#define Logo4_Reg5370			0x808010
#define Logo4_Reg5374			0x8080eb
#define Logo4_Reg5378			0xb46110
#define Logo4_Reg537c			0x004034
#define Logo4_Type_PAL
#define Logo4_File_Name			"logo_Emtec_V800H_PAL.bmp"
#define Logo5_Source_FLASH
#define Logo5_Offset			2575
#define Logo5_Reg5370			0x808010
#define Logo5_Reg5374			0x8080eb
#define Logo5_Reg5378			0xb46110
#define Logo5_Reg537c			0x004034
#define Logo5_Type_PAL
#define Logo5_File_Name			"logo_Emtec_V800H_PAL.bmp"
#define Logo6_Source_NULL
#define Logo6_Type_PAL
#define Logo6_File_Name			"realtek_pal.bmp"
#define Logo7_Source_NULL
#define Logo7_Type_PAL
#define Logo7_File_Name			"realtek_pal.bmp"
#define Logo8_Source_NULL
#define Logo8_Type_PAL
#define Logo8_File_Name			"realtek_pal.bmp"
//********************************************************************
//Rescue Linux attribute
//********************************************************************
//flag                      value
//********************************************************************
#define Rescue_Source_FLASH
#define Rescue_Install_Key			0x09
#define Rescue_GPIO_Switch			TRUE
#define Rescue_Install_With_GPIO_Address			0xb801b124
#define Rescue_Install_With_GPIO_Mask			0x00000400
#define Rescue_Install_With_GPIO_Value			0x00000000	// low active
#define Rescue_Loader_Param			""
#define Rescue_File_Name			vmlinux.rescue.usb.flash.mars.bin.vfd.lzma
//********************************************************************
//Linux attribute
//********************************************************************
//flag                      value
//********************************************************************
#define Linux_Source_FLASH
#define Linux_Loader_Param			"go 803bc000 rootfstype=squashfs root=31:01 mtdparts="
//********************************************************************
//USB OTG device mode attribute
//********************************************************************
//flag                      value
//********************************************************************
#define USB_OTG_mode_Enabled
#define USB_OTG_mode_GPIO_Number			8
#define USB_OTG_mode_GPIO_Value			0x1
#define USB_OTG_mode_lower_speed_Enabled
//********************************************************************
//Shell Setup
//********************************************************************
//flag                      value
//********************************************************************
#define Cmd_compare_On
#define Cmd_comptime_On
#define Cmd_copy_On
#define Cmd_cp0_Off
#define Cmd_cp1_Off
#define Cmd_disk_On
#define Cmd_dump_On
#define Cmd_erase_On
#define Cmd_fill_On
#define Cmd_format_Off
#define Cmd_freadwrite_On
#define Cmd_go_On
#define Cmd_help_On
#define Cmd_info_On
#define Cmd_iping_On
#define Cmd_load_On
#define Cmd_port_On
#define Cmd_reset_On
#define Cmd_setenv_On
#define Cmd_stty_On
#define Cmd_test_On
#define Cmd_continue_On
#define Cmd_saveenv_On
//********************************************************************
//user defined 
//********************************************************************
//flag                      value
//********************************************************************
#define system_parameters_3 "POWERKEY_IRRP=A8579F00 POWERKEY_GPIO=42"
#define system_parameters_4 "12V5V_GPIO=44,hion"

#endif //#ifndef EXTERN_PARAM_H	
